/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedItemFrameBlockEntity
extends FramedBlockEntity {
    public static final int ROTATION_STEPS = 8;
    private final boolean glowing;
    private ItemStack heldItem = ItemStack.f_41583_;
    private int rotation = 0;

    public FramedItemFrameBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.blockEntityTypeFramedItemFrame.get(), pos, state);
        this.glowing = this.getBlockType() == BlockType.FRAMED_GLOWING_ITEM_FRAME;
    }

    public InteractionResult handleFrameInteraction(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_() && this.hasItem()) {
            if (!this.f_58857_.m_5776_()) {
                this.rotation = (this.rotation + 1) % 8;
                this.playSound(this.glowing ? SoundEvents.f_144158_ : SoundEvents.f_12017_);
                this.m_6596_();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
            return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
        }
        if (!stack.m_41619_() && !this.hasItem()) {
            if (!this.f_58857_.m_5776_()) {
                this.setItem(stack);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                player.m_150109_().m_6596_();
                this.playSound(this.glowing ? SoundEvents.f_144154_ : SoundEvents.f_12013_);
            }
            return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public void removeItem(Player player) {
        if (!player.m_7500_() && !player.m_150109_().m_36054_(this.heldItem)) {
            player.m_36176_(this.heldItem, false);
        }
        this.rotation = 0;
        this.setItem(ItemStack.f_41583_);
        this.playSound(this.glowing ? SoundEvents.f_144157_ : SoundEvents.f_12016_);
    }

    private void setItem(ItemStack item) {
        if (item.m_41619_()) {
            this.heldItem = ItemStack.f_41583_;
        } else {
            this.heldItem = item.m_41777_();
            this.heldItem.m_41764_(1);
        }
        this.m_6596_();
        if (!this.changeMapStateIfNeeded()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean hasItem() {
        return !this.heldItem.m_41619_();
    }

    public ItemStack getItem() {
        return this.heldItem;
    }

    public int getRotation() {
        return this.rotation;
    }

    public boolean isGlowingFrame() {
        return this.glowing;
    }

    private boolean changeMapStateIfNeeded() {
        boolean mapState;
        boolean mapItem = !this.heldItem.m_41619_() && this.heldItem.m_41720_() instanceof MapItem;
        if (mapItem != (mapState = ((Boolean)this.m_58900_().m_61143_((Property)PropertyHolder.MAP_FRAME)).booleanValue())) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)PropertyHolder.MAP_FRAME, (Comparable)Boolean.valueOf(mapItem)));
            return true;
        }
        return false;
    }

    private void playSound(SoundEvent sound) {
        this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), sound, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void readFromNetwork(CompoundTag tag) {
        this.heldItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("item"));
        this.rotation = tag.m_128445_("rotation");
    }

    private void writeToNetwork(CompoundTag tag) {
        tag.m_128365_("item", (Tag)this.heldItem.m_41739_(new CompoundTag()));
        tag.m_128344_("rotation", (byte)this.rotation);
    }

    @Override
    protected boolean readFromDataPacket(CompoundTag tag) {
        this.readFromNetwork(tag);
        return super.readFromDataPacket(tag);
    }

    @Override
    protected void writeToDataPacket(CompoundTag tag) {
        super.writeToDataPacket(tag);
        this.writeToNetwork(tag);
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.readFromNetwork(tag);
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.writeToNetwork(tag);
        return tag;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.heldItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("item"));
        this.rotation = tag.m_128445_("rotation");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("item", (Tag)this.heldItem.m_41739_(new CompoundTag()));
        tag.m_128344_("rotation", (byte)this.rotation);
    }
}

